#!/usr/bin/env python

#GUI front-end for bps

from gtk import *
import GtkExtra
import os
import string 
import socket 

#globals

wins = {}
logdirectory = [os.path.expanduser("~/bps-logs")]
numprocs=["1","2","4","8","16","32","64"]
numproc = ["1"]
#interfaces=["Fast Ethernet","Gigabit Ethernet","Myrinet","Giganet","Dolphin SCI","Quadrics"]
interfaces=["Fast Ethernet"]
pipeinterface=["Fast Ethernet"]
perfinterface=["Fast Ethernet"]
ts=["A","B","C","S"]
testsize=["S"]
cm=["gnu","pgi","intel"]
compiler=["gnu"]
mpis=["lam","mpich","mpipro","dummy"]
mpi=["dummy"]
machinename=[""]
mboardman=[""]
mboardmod=[""]
memtype=[""]
netcon=[""]
linux=[""]
port1 = [""]
port2 = [""]
allstatus = [1]
status = [FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE]
prompting = [TRUE]

#Event handling and management

def delete_event(win, event=None):
	win.hide()
	return TRUE

def do_exit(button):
	mainquit()

#Message display handling

def display_info(_menuitem):
	GtkExtra.message_box("BPS Benchmark Descriptions",
	"Bonnie++ - Hardware performance\nStream - Memory bandwith\nNetPerf - Simple UDD and TCP communication testing for fixed packet size\nNetPipe - Measures varying TCP packet size performance\nNAS Parallel Benchmark - Eight parallel benches\nUnixbench - General Unix benchmarking" 
	,("OK",))

def display_about(_menuitem):
	GtkExtra.message_box("About BPS",
	"Paralogic Beowulf Performance Suite\nPortions (c) 2002 Paralogic, Inc.\nwww.plogic.com/bps"
	,("OK",))

def display_help(_menuitem):
	GtkExtra.message_box("BPS Operation Instructions",
	"1. Select the benchmark programs you wish to perform by pressing its button.\n2. Press the \"Run selected benchmarks\" button to begin running the benchmarks.\n3. Once complete, an html file of output can be obtained by pressing the \"Create html file of results\" button.  "
	,("OK",))

def display_running_window(benchName):
	GtkExtra.message_box("Benchmark Starting",
	benchName+" will be started, press ok to continue" 
	"",("OK",))	

#Variable toggling

def toggle_status(val):
	if status[val]==TRUE:
		status[val]=FALSE
	else:
		status[val]=TRUE

def toggle_prompting():
	if prompting[0]==TRUE:
		prompting[0]=FALSE
		string="OFF"
	else:
		prompting[0]=TRUE
		string="ON"

#Interface creation

def create_file_selection(entry):
	win = GtkFileSelection("Log directory selection")
	win.set_filename(logdirectory[0])
	win.set_modal(TRUE)
	win.hide_fileop_buttons()
	win.connect("delete_event", delete_event)

	def file_selection_ok(_button, fs=win,entry=entry):
		logdirectory[0]=fs.get_filename()
		if not os.path.isdir(logdirectory[0]):
			templog=logdirectory[0]
			logdirectory[0]=templog[0:string.rfind(templog,'/')+1]
			entry.set_text(logdirectory[0])
		if os.path.samefile(logdirectory[0],os.environ['HOME']):
			os.system("ls")
		else:
			 entry.set_text(logdirectory[0])
		fs.hide()

	win.ok_button.connect("clicked", file_selection_ok)
	win.cancel_button.connect("clicked", win.hide)
	win.show()

def create_port_input(benchName):
	win = GtkWindow()
	win.set_usize(300,-1)
	win.connect("delete_event", delete_event)
	win.set_title(benchName+" Node Info Entry")
	win.set_modal(TRUE)
	box1 = GtkVBox()
	win.add(box1)
	box1.show()
	box2=GtkHBox(spacing = 5)
	box2.set_border_width(10)
	box1.pack_start(box2)
	box2.show()
	frame = GtkFrame("Receiver Node")
	box1.pack_start(frame)
	frame.show()
	box3=GtkVBox(spacing=5)
	box3.set_border_width(5)
	frame.add(box3)
	box3.show()
	entry = GtkEntry()
	entry.set_text(port1[0])
	box3.pack_start(entry)
	entry.show()
	separator = GtkHSeparator()
	box1.pack_start(separator, expand=FALSE)
	separator.show()
	box2=GtkVBox(spacing=10)
	box2.set_border_width(10)
	box1.pack_start(box2, expand=FALSE)
	box2.show()
	frame = GtkFrame("Sender Node")
	box1.pack_start(frame)
	frame.show()
	box3=GtkVBox(spacing=5)
	box3.set_border_width(5)
	frame.add(box3)
	box3.show()
	entry1 = GtkEntry()
	entry1.set_text(port2[0])
	box3.pack_start(entry1)
	entry1.show()
	separator = GtkHSeparator()
	box1.pack_start(separator, expand=FALSE)
	separator.show()
	box2=GtkVBox(spacing=10)
	box2.set_border_width(10)
	box1.pack_start(box2, expand=FALSE)
	box2.show()
#	frame=GtkFrame("Interface")
#	box2.pack_start(frame)
#	frame.show()
#	interBox = GtkCombo()
#	frame.add(interBox)
#	interBox.set_popdown_strings(interfaces)
#	if (benchName=="Netpipe"):
#		interBox.entry.set_text(pipeinterface[0])
#	else:
#		interBox.entry.set_text(perfinterface[0])
#	interBox.show()	
#	def get_info(_button, win=win, entry=entry, interBox=interBox,benchName=benchName):
	def get_info(_button, win=win, entry=entry, entry1=entry1):
		port1[0]=entry.get_text()
		port2[0]=entry1.get_text()
#		if (benchName=="Netpipe"):
#			pipeinterface[0]=interBox.entry.get_text()
#		else:
#			perfinterface[0]=interBox.entry.get_text()
		win.hide()
	button2=GtkButton("Ok")
	button2.set_flags(CAN_DEFAULT)
	box2.pack_start(button2)
	button2.grab_default()
	button2.show()
	button2.connect("clicked",get_info)
	win.show()

def create_menu(num,info):
	menu = GtkMenu()
	group = None
	for i in range(num):
		menuitem=GtkRadioMenuItem(group,info[i])
		group = menuitem
		menu.append(menuitem)
		menuitem.show()
	return menu

def create_machine_input():
	win = GtkWindow()
	win.set_usize(300,-1)
	win.connect("delete_event", delete_event)
	win.set_title("Machine Info Entry")
	box1 = GtkVBox()
	win.add(box1)
	box1.show()
	frame = GtkFrame("Motherboard Manufacturer")
	box1.pack_start(frame)
	frame.show()
	entry1 = GtkEntry()
	frame.add(entry1)
	entry1.set_text(mboardman[0])
	entry1.show()
	frame=GtkFrame("Motherboard Model")
	box1.pack_start(frame)
	frame.show()
	entry5=GtkEntry()
	frame.add(entry5)
	entry5.set_text(mboardmod[0])
	entry5.show()
	frame = GtkFrame("Memory Type")
	box1.pack_start(frame)
	frame.show()
	entry2 = GtkEntry()
	frame.add(entry2)
	entry2.set_text(memtype[0])
	entry2.show()
	frame = GtkFrame("Interconnects")
	box1.pack_start(frame)
	frame.show()
	entry3 = GtkEntry()
	frame.add(entry3)
	entry3.set_text(netcon[0])
	entry3.show()
	frame = GtkFrame("Linux Distribution")
	box1.pack_start(frame)
	frame.show()
	entry4 = GtkEntry()
	frame.add(entry4)
	entry4.set_text(linux[0])
	entry4.show()
	separator = GtkHSeparator()
	box1.pack_start(separator, expand=FALSE)
	separator.show()
	box4=GtkVBox(spacing=10)
	box4.set_border_width(10)
	box1.pack_start(box4, expand=FALSE)
	box4.show()
	def get_info(_button, win=win, entry1=entry1, entry2=entry2, entry3=entry3, entry4=entry4,entry5=entry5):
		mboardman[0]=entry1.get_text()
		mboardmod[0]=entry5.get_text()
		memtype[0]=entry2.get_text()
		netcon[0]=entry3.get_text()
		linux[0]=entry4.get_text()
		win.hide()
	button=GtkButton("Ok")
	button.set_flags(CAN_DEFAULT)
	box4.pack_start(button)
	button.grab_default()
	button.show()
	button.connect("clicked",get_info)
	win.show()

def create_npb_input(run_mode):
	win = GtkWindow()
	win.set_usize(300,-1)	
	win.connect("delete_event", delete_event)
	win.set_title("NAS Benchmark Info Entry")
	box1 = GtkVBox()
	win.add(box1)
	box1.show()
	box2=GtkHBox(spacing = 5)
	box2.set_border_width(10)
	box1.pack_start(box2)
	box2.show()
	frame = GtkFrame("Compiler")
	box2.pack_start(frame)
	frame.show()
	compilerbox=GtkCombo()
	frame.add(compilerbox)
	compilerbox.set_popdown_strings(cm)
	compilerbox.entry.set_text(compiler[0])
	compilerbox.show()
	frame = GtkFrame("MPI Version")
	box2.pack_start(frame)
	frame.show()
	mpibox=GtkCombo()
	frame.add(mpibox)
	mpibox.set_popdown_strings(mpis)
	mpibox.entry.set_text(mpi[0])
	mpibox.show()
	box3=GtkHBox(spacing = 5)
	box3.set_border_width(10)
	box1.pack_start(box3)
	box3.show()
	frame=GtkFrame("Test Size")
	box3.pack_start(frame)
	frame.show()
	testbox=GtkCombo()
	frame.add(testbox)
	testbox.set_popdown_strings(ts)
	testbox.entry.set_text(testsize[0])
	testbox.show()
	frame = GtkFrame("Number of Processors")
	box3.pack_start(frame)
	frame.show()
	processorbox=GtkCombo()
	frame.add(processorbox)
	processorbox.set_popdown_strings(numprocs)
	processorbox.entry.set_text(numproc[0])
	processorbox.show()
	frame=GtkFrame("Machine Names (<name1>,<name2>,...,<namen>)")
	box1.pack_start(frame)
	frame.show()
	machineentry=GtkEntry()
	frame.add(machineentry)
	machineentry.set_text(machinename[0])
	machineentry.show()
	sep=GtkHSeparator()
	box1.pack_start(sep)
	sep.show()
	box4=GtkHBox(spacing = 5)
	box4.set_border_width(10)
	box1.pack_start(box4)
	box4.show()
	if (run_mode):
		button=GtkButton("Run NAS")
	else:
		button=GtkButton("OK")
	box4.pack_start(button)

	def npb_ok(_button,win=win,processorbox=processorbox,
			testbox=testbox,compilerbox=compilerbox,
			mpibox=mpibox,run_mode=run_mode,machineentry=machineentry):
		numproc[0]=processorbox.entry.get_text()
		testsize[0]=testbox.entry.get_text()
		compiler[0]=compilerbox.entry.get_text()
		mpi[0]=mpibox.entry.get_text()
		machinename[0]=machineentry.get_text()
		if(run_mode): os.system("run_suite -c "+compiler[0]+" -n "+numproc[0]+" -t "+testsize[0]+" -m "+mpi[0])
		win.hide()

	button.show()
	button.connect("clicked",npb_ok)
	win.show()

def create_log_select():
	win = GtkWindow()
	win.set_usize(300,-1)	
	win.connect("delete_event", delete_event)
	win.set_title("Log Directory Info Entry")
	box1 = GtkVBox()
	win.add(box1)
	box1.show()
	box2 = GtkHBox(spacing = 5)
	box2.set_border_width(10)
	box1.pack_start(box2)
	box2.show()
	frame = GtkFrame("Log Directory")
	box2.pack_start(frame)
	frame.show()
	box3=GtkHBox(spacing=5)
	box3.set_border_width(5)
	frame.add(box3)
	box3.show()
	entry = GtkEntry()
	entry.set_text(logdirectory[0])
	box3.pack_start(entry)
	entry.show()
	button = GtkButton("Browse")
	box3.add(button)
	button.show()
	def browse(_button, win=win, entry=entry):
		create_file_selection(entry)
	button.connect("clicked",browse)
	separator = GtkHSeparator()
	box1.pack_start(separator, expand=FALSE)
	separator.show()
	box2=GtkVBox(spacing=10)
	box2.set_border_width(10)
	box1.pack_start(box2, expand=FALSE)
	box2.show()

	def logdirok(_button,win=win,entry=entry):
		logdirectory[0]=entry.get_text()
		logdirectory[0]=os.path.expanduser(logdirectory[0])
		win.hide()

	button2 = GtkButton("Ok")
	button2.set_flags(CAN_DEFAULT)
	box2.pack_start(button2)
	button2.grab_default()
	button2.show()
	button2.connect("clicked",logdirok)
	win.show()

#Process execution and handling

def html_script():
	os.system("bps-html "+logdirectory[0])

def run_html():
	win = GtkWindow()
	win.set_usize(300,-1)	
	win.connect("delete_event",delete_event)
	win.set_title("Log Directory Info Entry")
	box1=GtkVBox()
	win.add(box1)
	box1.show()
	box2=GtkHBox(spacing = 5)
	box2.set_border_width(10)
	box1.pack_start(box2)
	box2.show()
	frame=GtkFrame("Log File Directory")
	box2.pack_start(frame)
	frame.show()
	box3=GtkHBox(spacing=5)
	box3.set_border_width(5)
	frame.add(box3)
	box3.show()
	entry=GtkEntry()
	entry.set_text(logdirectory[0])
	box3.pack_start(entry)
	entry.show()
	button=GtkButton("Browse")
	box3.add(button)
	def browse(_button, entry=entry):
		create_file_selection(entry)	
	button.connect("clicked",browse)
	button.show()
	separator=GtkHSeparator()
	box3.show()
	box1.pack_start(separator,expand=FALSE)
	separator.show()
	box2=GtkVBox(spacing=10)
	box2.set_border_width(10)
	box1.pack_start(box2, expand=FALSE)
	box2.show()
	def run_script(_button, win=win, entry=entry):
		logdirectory[0]=entry.get_text()
		html_script()
		win.hide()
	button2 = GtkButton("Generate Html File")
	button2.set_flags(CAN_DEFAULT)
	box2.pack_start(button2)
	button2.grab_default()
	button2.show()
	button2.connect("clicked",run_script)	
	win.show()

def run_bench():
	over_write=" -w"
	machine_info=" -i \""+mboardman[0]+","+mboardmod[0]+","+memtype[0]+","+netcon[0]+","+linux[0]+"\""
	if not prompting[0]:
		GtkExtra.message_box("Beginning benches",
		"Selected benchmarks will be run\nNo further prompting will be given."
		,("OK",))

	for i in range(0,7):
		if i==0 and status[i]:
			if prompting[0]: display_running_window("Bonnie++")
			os.system("bps"+over_write+" -l "+logdirectory[0]+machine_info+" -b")
			over_write=""
		if i==1 and status[i]:
			if prompting[0]: display_running_window("Stream")
			os.system("bps"+over_write+" -l "+logdirectory[0]+machine_info+" -s")
			over_write=""
		if i==2 and status[i]:
			try:
				socket.gethostbyname(port1[0])
				val=1;
			except:
				GtkExtra.message_box("Invalid Node",
				"The node " + port1[0] + " is unreachable"
				,("OK",))
				val=0;
			try:
				socket.gethostbyname(port2[0])
				val=1;
			except:
				GtkExtra.message_box("Invalid Node",
				"The node " + port2[0] + " is unreachable"
				,("OK",))
				val=0;
				
			if (port1[0]=="" or port2[0]==""):
				GtkExtra.message_box("No Node Initialization",
				"A remote node for Netperf has not been specified\nSpecify the node by clicking the Netperf section under Settings"
				,("OK",))
			elif val==1:
				if (prompting[0]): display_running_window("Netperf")
				tempstring = "bps"+over_write+" -l "+logdirectory[0]+machine_info+" -f \""+port2[0]+","+port1[0]+"\""
				os.system(tempstring)	
				over_write=""
		if i==3 and status[i]:
			try:
				socket.gethostbyname(port1[0])
				val=1;
			except:
				GtkExtra.message_box("Invalid Node",
				"The node " + port1[0] + " is unreachable"
				,("OK",))
				val=0;
			try:
				socket.gethostbyname(port2[0])
				val=1;
			except:
				GtkExtra.message_box("Invalid Node",
				"The node " + port2[0] + " is unreachable"
				,("OK",))
				val=0;
				
			if (port1[0]=="" or port2[0]==""):
				GtkExtra.message_box("No Node Initialization",
				"A remote node for Netpipe has not been specified\nSpecify the node by clicking the Netpipe section under Settings"
				,("OK",))
			elif val==1:
				if (prompting[0]): display_running_window("Netpipe")
				tempstring="bps"+over_write+" -l "+logdirectory[0]+machine_info+" -p \""+port2[0]+","+port1[0]+"\""
				os.system(tempstring)
				over_write=""
		if i==4 and status[i]:
			if prompting[0]: display_running_window("NAS")
			tempstring="bps" + over_write + " -l "+logdirectory[0]+machine_info+" -n "+compiler[0]+","+numproc[0]+","+testsize[0]+","+mpi[0]+","+machinename[0]
			os.system(tempstring)
			over_write=""
		if i==5 and status[i]:		
			if prompting[0]: display_running_window("UnixBench")
			os.system("bps"+over_write+" -l "+logdirectory[0]+machine_info+" -u")
			over_write=""
		if i==6 and status[i]:
			if prompting[0]: display_running_window("LMBench")
			os.system("bps"+over_write+" -l "+logdirectory[0]+machine_info+" -m")
			over_write=""
	if over_write=="": return 1
	else: return 0
			
#main function - separate from the other "create" functions due to 
#Python scoping rules

def create_main_window():
	buttons = {} 
	def html_hook(_b):
		run_html()
	
	def select_all(_b,buttons=buttons):
		for i in range(0,7):
			buttons[i].set_active(allstatus[0])
			status[i]=allstatus[0]
		allstatus[0]=not allstatus[0]
			
	def run_benches(_b,buttons=buttons):
		ran=run_bench()
		for i in range(0,7):
			buttons[i].set_active(FALSE)
		if (ran==1): GtkExtra.message_box("Benchmarks Completed",
		"All selected benchmarks have completed"
		,("OK",))
	win = GtkWindow()
	win.set_name("main window")
	win.set_usize(700,-1)	
	win.set_uposition(20, 20)
	win.connect("destroy", mainquit)
	win.connect("delete_event", mainquit)
	win.set_title("Paralogic Beowulf Performance Suite")
	box1 = GtkVBox()
	win.add(box1)
	box1.show()
	file_menu = GtkMenu()
	run_item = GtkMenuItem("Run")
	select_item = GtkMenuItem("(Un)Select All")
	html_item = GtkMenuItem("Create Html")
	exit_item = GtkMenuItem("Exit")
	file_menu.append(run_item)
	file_menu.append(select_item)
	file_menu.append(html_item)
	file_menu.append(exit_item)
	run_item.connect("activate",run_benches)
	run_item.show()
	select_item.connect("activate",select_all)
	select_item.show()
	html_item.connect("activate",html_hook)
	html_item.show()
	exit_item.connect("activate",do_exit)
	exit_item.show()

	def perf_port_hook(_b):
		create_port_input("Netperf")
	def pipe_port_hook(_b):
		create_port_input("Netpipe")
	def log_hook(_b):
		create_log_select() 
	def prompt_hook(_b):
		toggle_prompting()	
	def npb_hook(_b):
		create_npb_input(FALSE)
	def machine_hook(_b):
		create_machine_input()

	settings_menu = GtkMenu()
	logdir_item = GtkMenuItem("Log Dir")
	port_item = GtkMenuItem("Netperf")
	netpipe_item = GtkMenuItem("Netpipe")
	npb_item = GtkMenuItem("NAS")
	machine_item = GtkMenuItem("Machine Info")
	prompt_item = GtkCheckMenuItem("Prompting")
	prompt_item.set_active(prompting[0])
	settings_menu.append(logdir_item)
	settings_menu.append(port_item)
	settings_menu.append(netpipe_item)
	settings_menu.append(npb_item)
	settings_menu.append(machine_item)
	settings_menu.append(prompt_item)
	logdir_item.connect("activate",log_hook)
	logdir_item.show()
	port_item.connect("activate",perf_port_hook)
	port_item.show()
	netpipe_item.connect("activate",pipe_port_hook)
	netpipe_item.show()
	npb_item.connect("activate",npb_hook)
	npb_item.show()
	machine_item.connect("activate", machine_hook)
	machine_item.show()
	prompt_item.connect("toggled",prompt_hook)
	prompt_item.show()
	help_menu = GtkMenu()
	general_item = GtkMenuItem("General Operation")
	bench_item = GtkMenuItem("Benchmark Info")
	about_item = GtkMenuItem("About")
	help_menu.append(general_item)
	help_menu.append(bench_item)
	help_menu.append(about_item)
	general_item.connect("activate",display_help)
	bench_item.connect("activate",display_info)
	about_item.connect("activate",display_about)
	general_item.show()
	bench_item.show()
	about_item.show()

	menu_bar = GtkMenuBar()
	box1.pack_start(menu_bar,expand=FALSE)
	menu_bar.show()
	file_item = GtkMenuItem("File")
	file_item.show()
	file_item.set_submenu(file_menu)
	settings_item = GtkMenuItem("Settings")
	settings_item.show()	
	settings_item.set_submenu(settings_menu)
	help_item = GtkMenuItem("Help")
	help_item.show()
	help_item.set_submenu(help_menu)
	menu_bar.append(file_item)
	menu_bar.append(settings_item)
	menu_bar.append(help_item)

	frame = GtkFrame("Benchmarks")
	box1.pack_start(frame)
	frame.show()
	table = GtkTable(2, 4, FALSE)
	table.set_col_spacings(5)
	table.set_border_width(10)
	frame.add(table)
	table.show()

	box2 = GtkHButtonBox()
	box2.set_usize(-1,-1)
	box2.set_spacing(20)
	box2.set_layout(BUTTONBOX_SPREAD)
	box2.set_border_width(5)
	box1.add(box2)
	box2.show()

	def bbox_bonnie(_b, bbox=box2):
		toggle_status(0)
	def bbox_stream(_b, bbox=box2):
		toggle_status(1)
	def bbox_netperf(_b, bbox=box2):
		toggle_status(2)
	def bbox_netpipe(_b, bbox=box2):
		toggle_status(3)
	def bbox_npb(_b, bbox=box2):
		toggle_status(4)
	def bbox_unixbench(_b, bbox=box2):
		toggle_status(5)		
	def bbox_lmbench(_b, bbox=box2):
		toggle_status(6)

	buttons[0] = GtkToggleButton("Bonnie++")
	buttons[0].connect("toggled",bbox_bonnie)
	table.attach(buttons[0],1,2,1,2)
	buttons[0].show()

	buttons[1] = GtkToggleButton("Stream")
	buttons[1].connect("toggled",bbox_stream)
	table.attach(buttons[1],1,2,2,3)
	buttons[1].show()

	buttons[2] = GtkToggleButton("NetPerf")
	buttons[2].connect("toggled",bbox_netperf)
	table.attach(buttons[2],1,2,3,4)
	buttons[2].show()

	buttons[3] = GtkToggleButton("NetPipe")
	buttons[3].connect("toggled",bbox_netpipe)
	table.attach(buttons[3],2,3,1,2)
	buttons[3].show()

	buttons[4] = GtkToggleButton("NAS")
	buttons[4].connect("toggled",bbox_npb)
	table.attach(buttons[4],2,3,2,3)
	buttons[4].show()

	buttons[5] = GtkToggleButton("UnixBench")
	buttons[5].connect("toggled",bbox_unixbench)
	table.attach(buttons[5],2,3,3,4)
	buttons[5].show()

	buttons[6] = GtkToggleButton("LMBench")
	buttons[6].connect("toggled",bbox_lmbench)
	table.attach(buttons[6],1,2,4,5)
	buttons[6].show()
	
	button = GtkButton("(Un)Select all")
	button.connect("clicked", select_all)
	box2.add(button)
	button.show()
	
	button = GtkButton("Run selected benches")
	button.connect("clicked", run_benches)
	box2.add(button)
	button.show()

	button = GtkButton("Create html file of results")
	button.connect("clicked", html_hook)
	box2.add(button)
	button.show()

	button = GtkButton("Exit BPS")
	button.connect("clicked", do_exit)
	button.set_flags(CAN_DEFAULT)
	box2.add(button)
	button.grab_default()
	button.show()
	win.show()

def main():
	create_main_window()
	mainloop()

#try:
	#os.environ['DISPLAY']
main()
#except:
#	print "Set your DISPLAY variable and try again"

